﻿#nullable enable
namespace Hims.Api.Models.Patient
{
    using System;
    using System.Collections.Generic;
    using Microsoft.AspNetCore.Http;
    using Shared.EntityModels;

    /// <summary>
    /// The modify patient request.
    /// </summary>
    public class BabyregistrationRequest
    {
        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }
        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }
        /// <summary>
        /// Gets or sets the emergency contacts.
        /// </summary>
        public List<PatientEmergencyModel>? EmergencyContacts { get; set; }

        /// <summary>
        /// Gets or sets the insurances.
        /// </summary>
        public List<PatientInsuranceModel>? Insurances { get; set; }

        /// <summary>
        /// Gets or sets the relative details.
        /// </summary>
        public List<PatientFamilyModel>? RelativeDetails { get; set; }
        public List<ModifyPatientRequest> BabyDetails { get; set; }
        public string BabyData { get; set; }
    }
}